<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Distribuidora extends Model 
{

    protected $table = 'distribuidoras';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'pais_id', 'code', 'tipo_distribuidora_id');
    protected $visible = array('name', 'description', 'pais_id', 'tipo_distribuidora_id');
    protected $hidden = array('code');

    public function tipo_distribuidora()
    {
        return $this->belongsTo('TipoDistribuidora', 'tipo_distribuidora_id')->withTrashed();
    }

    public function pais()
    {
        return $this->belongsTo('Pais', 'pais_id')->withTrashed();
    }

}